/*  
 * Ape Gallery			
 * Author:            	Wp Gallery Ape 
 * Author URI:        	https://wpape.net/
 * License:           	GPL-2.0+
 */

(function ($) {
	
	var ape_gallery_images_preview_div = $('#ape_gallery_images_preview');
	var wpapeGalleryFieldImagesButton = null;

    $(document).ready(function () {
    	$('.wpapeGalleryFieldImagesButton').each(function() {
			var button = this;
			var buttonObj = $(this);
			wpapeGalleryFieldImagesButton = buttonObj;

			var idField = jQuery( buttonObj.data('id') );

			wpapeGalleryUpdateImages( idField.val() );

			buttonObj.click(function(event){
				event.preventDefault();
				var idList = idField.val();
				var gallerysc = '[gallery ids="' +idList+ '"]';
	  			wp.media.gallery.edit(gallerysc).on('update', function(g){
					var id_array = [];
					var marginCount = 0;
					$.each(g.models, function(id, img) { ++marginCount; id_array.push(img.id); });
					idField.val(id_array.join(","));
					wpapeGalleryUpdateImages( idField.val() );
				});
	  			if(idList==' ' || idList=='' ){
	  				$('.media-frame-menu .media-menu-item').eq(2).click();
	  			}
			});
		});
	});

	ape_gallery_images_preview_div.on('click', 'img', function(event) {
		event.preventDefault();
		wpapeGalleryFieldImagesButton.click();
	});

	function wpapeGalleryUpdateImages( idString ){
		var data = {
			'action': 'wpape_gallery_get_images_from_ids',
			'idstring': idString
		};
		jQuery.post(ajaxurl, data, function(response) {

			ape_gallery_images_preview_div.html(response);
			
			var imgCount = ape_gallery_images_preview_div.find('img').length;
			
			if(imgCount <=10 ){
				ape_gallery_images_preview_div.addClass('items10');
			} else if(imgCount <=20 ){
				ape_gallery_images_preview_div.addClass('items20');
			} else if(imgCount <=30 ){
				ape_gallery_images_preview_div.addClass('items30');	
			} else {
				ape_gallery_images_preview_div.addClass('items50');
			}
			//var itemList = $('twoj_slideshow_preview_div');
			//ape_gallery_images_preview_div.sortable({});
		});
	}


})(jQuery);